/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.attention;

import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.CriticalProblem;
import java.util.Date;

public class CommonProblemAttention
extends Attention {
    private static final String TRACE_MASKT = "XPAATTNT";
    private static final String TRACE_MASKF = "XPAATTNF";
    private static final String TRACE_MASKD = "XPAATTND";
    private static final boolean UNIT_TEST = true;
    private static final String COMMON_PA_DETAILS_CALL_NAME = "com.ibm.hwmca.xfw.pa.tasks.spi.PrimaryProblemAnalysisServerTasklet";
    private CommonProblem _theProblem;

    public CommonProblemAttention(ObjectId moID, LocalizableText text) {
        super(moID, text, new Date());
        this._theProblem = null;
        Trace.trace(TRACE_MASKD, "--> CommonProblemAttention.ctor");
    }

    public CommonProblemAttention(PersistentData persistentData, String key) throws PersistenceException {
        block3: {
            super(((CommonProblemPersistentData)persistentData).parentData, key);
            this._theProblem = null;
            Trace.trace(TRACE_MASKT, "--> CommonProblemAttention(PersistentData)");
            try {
                CommonProblemPersistentData perData = (CommonProblemPersistentData)persistentData;
                String uuid = perData.uuId;
                Trace.trace(TRACE_MASKD, "get problem [" + uuid + "] from the problem manager");
                this._theProblem = (CommonProblem)ProblemManager.getProblemManager().getProblem(uuid);
                if (this._theProblem != null) break block3;
                Trace.trace(TRACE_MASKD, "!!!!!!!!!!!!!!!!!!!!");
                Trace.trace(TRACE_MASKD, "the problem was null");
                Trace.trace(TRACE_MASKD, "!!!!!!!!!!!!!!!!!!!!");
                if (perData.version > 1L) {
                    this._theProblem = new CriticalProblem(perData.refcode, perData.extension);
                    break block3;
                }
                Trace.trace(TRACE_MASKD, "throw and exception to get rid of the data");
                throw new PersistenceException("Detail data missing");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "got an exception");
                Trace.trace(TRACE_MASKF, e);
                Trace.trace(TRACE_MASKT, "<-- CommonProblemAttention(PersistentData)");
                throw new PersistenceException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- CommonProblemAttention(PersistentData)");
    }

    public PersistentData getPersistentData() {
        CommonProblemPersistentData perData = new CommonProblemPersistentData();
        perData.version = 2L;
        perData.parentData = super.getPersistentData();
        perData.uuId = this._theProblem.getUniqueKey();
        perData.refcode = this._theProblem.getRefcode();
        perData.extension = this._theProblem.getExtension();
        return perData;
    }

    public CommonProblem getProblem() {
        return this._theProblem;
    }

    public void setProblem(CommonProblem aProblem) {
        this._theProblem = aProblem;
    }

    public String getAttentionDetailsClassName() {
        return COMMON_PA_DETAILS_CALL_NAME;
    }

    public boolean isUpgradeData() {
        return false;
    }

    private static class CommonProblemPersistentData
    implements PersistentData {
        private static final long serialVersionUID = -1L;
        public static final long CURRENT_VERSION = 2L;
        public long version;
        public PersistentData parentData = null;
        public String uuId;
        public String refcode;
        public String extension;

        private CommonProblemPersistentData() {
        }
    }
}

